<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="xml" indent="yes"/>

  <xsl:variable name="vars" select="document('vars.xml')/vars"/>
  
  <xsl:template match="/">
    <xsl:text disable-output-escaping="yes">
      <![CDATA[
        <!DOCTYPE HelpTOC SYSTEM "ms-help://hx/resources/HelpTOC.DTD">
        ]]>
      </xsl:text>
      <xsl:element name="HelpTOC">
          <xsl:attribute name="DTDVersion">1.0</xsl:attribute>
          <xsl:attribute name="FileVersion">1.0</xsl:attribute>
          <xsl:attribute name="LangId"><xsl:value-of select="$vars//localeid/langid"/></xsl:attribute>

    <!-- #### namespace #### -->
    <xsl:for-each select="/toc/namespace">
      <xsl:variable name="namespace" select="@name"/>
      
      <HelpTOCNode>
        <xsl:attribute name="Title">
          <xsl:value-of select="$namespace"/>
        </xsl:attribute>
          <xsl:attribute name="Url">
            <xsl:variable name="class_string" 
                select="concat('html/', $namespace, 'Namespace')"/>
            <xsl:value-of select="translate($class_string, '.', '')"/>
            <xsl:text>.htm</xsl:text>
          </xsl:attribute>

          

      <!-- #### class #### -->
      <xsl:if test="./class">
        
        <HelpTOCNode>
          <xsl:attribute name="Title">
            <xsl:value-of select="$vars/localizable/classes"/>
          </xsl:attribute>

      <xsl:for-each select="class">
        <xsl:variable name="class" select="@name"/>
        <HelpTOCNode>
          <xsl:attribute name="Title">
            <xsl:value-of select="$class"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/class"/>
          </xsl:attribute>

          <xsl:attribute name="Url">
            <xsl:variable name="class_string" select="concat('html/', $namespace, $class, 'Class')"/>
            <xsl:value-of select="translate($class_string, '.', '')"/><xsl:text>.htm</xsl:text>
          </xsl:attribute>

          <!-- members -->

          <xsl:if test="./properties/property | ./methods/method | ./events/event 
                        | ./propertylinks[@haslinks='yes'] | ./methodlinks[@haslinks='yes']
                        | ./eventlinks[@haslinks='yes']">
            <HelpTOCNode>
              <xsl:attribute name="Title">
                <xsl:value-of select="$class"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/members"/>
              </xsl:attribute>
              
              <xsl:attribute name="Url">
                <xsl:variable name="const_string" select="concat('html/', $namespace, $class, 'Members')"/> 
                <xsl:value-of select="translate($const_string, '.', '')"/><xsl:text>.htm</xsl:text>
              </xsl:attribute>
              
            </HelpTOCNode>
          </xsl:if>
          
          <xsl:if test="./properties/property | ./propertylinks[@haslinks='yes']">
            <HelpTOCNode>
              <xsl:attribute name="Title">
                <xsl:value-of select="$vars/localizable/properties"/>
              </xsl:attribute>
              <xsl:attribute name="Url">
                <xsl:variable name="prop_string" select="concat('html/', $namespace, $class, 'Properties')"/> 
                <xsl:value-of select="translate($prop_string, '.', '')"/><xsl:text>.htm</xsl:text>
              </xsl:attribute>
              <xsl:for-each select="properties/property">
                <xsl:variable name="property">
                  <xsl:value-of select="."/>
                </xsl:variable>
                <HelpTOCNode>
                  <xsl:attribute name="Title">
                    <xsl:value-of select="$property"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/property"/>
                  </xsl:attribute>
                  
                  <xsl:attribute name="Url">
                    <xsl:variable name="prop_string" select="concat('html/', $namespace, $class, $property, 'Property')"/> 
                    <xsl:value-of select="translate($prop_string, '.', '')"/><xsl:text>.htm</xsl:text>
                  </xsl:attribute>
                  
                </HelpTOCNode>
              </xsl:for-each>
            </HelpTOCNode>
          </xsl:if>

          <xsl:if test="./methods/method | ./methodlinks[@haslinks='yes']">
            <HelpTOCNode>
              <xsl:attribute name="Title">
                <xsl:value-of select="$vars/localizable/methods"/>
              </xsl:attribute>
              <xsl:attribute name="Url">
                <xsl:variable name="meth_string" select="concat('html/', $namespace, $class, 'Methods')"/> 
                <xsl:value-of select="translate($meth_string, '.', '')"/><xsl:text>.htm</xsl:text>
              </xsl:attribute>
              <xsl:for-each select="methods/method">
                <xsl:variable name="method">
                  <xsl:value-of select="."/>
                </xsl:variable>
                <HelpTOCNode>
                  <xsl:attribute name="Title">
                    <xsl:value-of select="$method"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/method"/>
                    <xsl:if test="@overloaded='true'">
                      <xsl:text> (</xsl:text><xsl:value-of select="$vars/localizable/overloaded"/><xsl:text>)</xsl:text>
                    </xsl:if>
                  </xsl:attribute>
                  
                  <xsl:attribute name="Url">
                    <xsl:variable name="meth_string" select="concat('html/', $namespace, $class, $method, 'Method')"/>
                    <xsl:value-of select="translate($meth_string, '.', '')"/><xsl:text>.htm</xsl:text>
                  </xsl:attribute>
                  
                </HelpTOCNode>         
              </xsl:for-each>
            </HelpTOCNode>
          </xsl:if>

          <xsl:if test="./events/event | ./eventlinks[@haslinks='yes']">
            <HelpTOCNode>
              <xsl:attribute name="Title">
                <xsl:value-of select="$vars/localizable/events"/>
              </xsl:attribute>
              <xsl:attribute name="Url">
                <xsl:variable name="event_string" select="concat('html/', $namespace, $class, 'Events')"/> 
                <xsl:value-of select="translate($event_string, '.', '')"/><xsl:text>.htm</xsl:text>
              </xsl:attribute>
              <xsl:for-each select="events/event">
                <xsl:variable name="event">
                  <xsl:value-of select="."/>
                </xsl:variable>
                <HelpTOCNode>
                  <xsl:attribute name="Title">
                    <xsl:value-of select="$event"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/event"/>
                  </xsl:attribute>
                  
                  <xsl:attribute name="Url">
                    <xsl:variable name="event_string" select="concat('html/', $namespace, $class, $event, 'Event')"/> 
                    <xsl:value-of select="translate($event_string, '.', '')"/><xsl:text>.htm</xsl:text>
                  </xsl:attribute>
                  
                </HelpTOCNode>
              </xsl:for-each>
            </HelpTOCNode>
          </xsl:if>


  </HelpTOCNode> <!-- current class -->
</xsl:for-each>
</HelpTOCNode> <!-- Classes node -->
</xsl:if>

      <!-- #### interface #### -->
        <xsl:if test="interface">
          <HelpTOCNode>
            <xsl:attribute name="Title">
              <xsl:value-of select="$vars/localizable/interfacesinnamespace"/>
            </xsl:attribute>
      <xsl:for-each select="interface"><!-- 1 -->

        <xsl:variable name="interface" select="@name"/>
        <HelpTOCNode>
          <xsl:attribute name="Title">
            <xsl:value-of select="$interface"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/interface"/>
          </xsl:attribute>

          <xsl:attribute name="Url">
            <xsl:variable name="interface_string" select="concat('html/', $namespace, $interface, 'Interface')"/>
            <xsl:value-of select="translate($interface_string, '.', '')"/><xsl:text>.htm</xsl:text>
          </xsl:attribute>

          <!-- members -->

          <xsl:if test="./properties/property | ./methods/method | ./events/event 
                        | ./propertylinks[@haslinks='yes'] | ./methodlinks[@haslinks='yes']
                        | ./eventlinks[@haslinks='yes']">
            <HelpTOCNode>
              <xsl:attribute name="Title">
                <xsl:value-of select="$interface"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/members"/>
              </xsl:attribute>
              
              <xsl:attribute name="Url">
                <xsl:variable name="const_string" select="concat('html/', $namespace, $interface, 'Members')"/> 
                <xsl:value-of select="translate($const_string, '.', '')"/><xsl:text>.htm</xsl:text>
              </xsl:attribute>
              
            </HelpTOCNode>
          </xsl:if>
          
          <xsl:if test="./properties/property | ./propertylinks[@haslinks='yes']">
            <HelpTOCNode>
              <xsl:attribute name="Title">
                <xsl:value-of select="$vars/localizable/properties"/>
              </xsl:attribute>
              <xsl:attribute name="Url">
                <xsl:variable name="prop_string" select="concat('html/', $namespace, $interface, 'Properties')"/> 
                <xsl:value-of select="translate($prop_string, '.', '')"/><xsl:text>.htm</xsl:text>
              </xsl:attribute>
              <xsl:for-each select="properties/property">
                <xsl:variable name="property">
                  <xsl:value-of select="."/>
                </xsl:variable>
                <HelpTOCNode>
                  <xsl:attribute name="Title">
                    <xsl:value-of select="$property"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/property"/>
                  </xsl:attribute>
                  
                  <xsl:attribute name="Url">
                    <xsl:variable name="prop_string" select="concat('html/', $namespace, $interface, $property, 'Property')"/> 
                    <xsl:value-of select="translate($prop_string, '.', '')"/><xsl:text>.htm</xsl:text>
                  </xsl:attribute>
                  
                </HelpTOCNode>
              </xsl:for-each>
            </HelpTOCNode>
          </xsl:if>

          <xsl:if test="./methods/method | ./methodlinks[@haslinks='yes']">
            <HelpTOCNode>
              <xsl:attribute name="Title">
                <xsl:value-of select="$vars/localizable/methods"/>
              </xsl:attribute>
              <xsl:attribute name="Url">
                <xsl:variable name="meth_string" select="concat('html/', $namespace, $interface, 'Methods')"/> 
                <xsl:value-of select="translate($meth_string, '.', '')"/><xsl:text>.htm</xsl:text>
              </xsl:attribute>
              <xsl:for-each select="methods/method">
                <xsl:variable name="method">
                  <xsl:value-of select="."/>
                </xsl:variable>
                <HelpTOCNode>
                  <xsl:attribute name="Title">
                    <xsl:value-of select="$method"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/method"/>
                    <xsl:if test="@overloaded='true'">
                      <xsl:text> (</xsl:text><xsl:value-of select="$vars/localizable/overloaded"/><xsl:text>)</xsl:text>
                    </xsl:if>
                  </xsl:attribute>
                  
                  <xsl:attribute name="Url">
                    <xsl:variable name="meth_string" select="concat('html/', $namespace, $interface, $method, 'Method')"/>
                    <xsl:value-of select="translate($meth_string, '.', '')"/><xsl:text>.htm</xsl:text>
                  </xsl:attribute>
                  
                </HelpTOCNode>         
              </xsl:for-each>
            </HelpTOCNode>
          </xsl:if>

          <xsl:if test="./events/event | ./eventlinks[@haslinks='yes']">
            <HelpTOCNode>
              <xsl:attribute name="Title">
                <xsl:value-of select="$vars/localizable/events"/>
              </xsl:attribute>
              <xsl:attribute name="Url">
                <xsl:variable name="event_string" select="concat('html/', $namespace, $interface, 'Events')"/> 
                <xsl:value-of select="translate($event_string, '.', '')"/><xsl:text>.htm</xsl:text>
              </xsl:attribute>
              <xsl:for-each select="events/event">
                <xsl:variable name="event">
                  <xsl:value-of select="."/>
                </xsl:variable>
                <HelpTOCNode>
                  <xsl:attribute name="Title">
                    <xsl:value-of select="$event"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/event"/>
                  </xsl:attribute>
                  
                  <xsl:attribute name="Url">
                    <xsl:variable name="event_string" select="concat('html/', $namespace, $interface, $event, 'Event')"/> 
                    <xsl:value-of select="translate($event_string, '.', '')"/><xsl:text>.htm</xsl:text>
                  </xsl:attribute>
                  
                </HelpTOCNode>
              </xsl:for-each>
            </HelpTOCNode>
          </xsl:if>

  </HelpTOCNode>
</xsl:for-each><!-- for all interfaces -->
</HelpTOCNode>
</xsl:if><!-- if there is an interface -->


    <!-- ##### types ##### -->

        <xsl:if test="type">
          <HelpTOCNode>
            <xsl:attribute name="Title">
              <xsl:value-of select="$vars/localizable/types"/>
            </xsl:attribute>
        <xsl:for-each select="type">

          <xsl:variable name="name">
            <xsl:value-of select="@name"/>
          </xsl:variable>
          <HelpTOCNode>
            <xsl:attribute name="Title">
              <xsl:value-of select="$name"/><xsl:text> </xsl:text>
              <xsl:choose>
                <xsl:when test="@variety='enum'">
                  <xsl:value-of select="$vars//localizable/enum"/>
                </xsl:when>
                <xsl:when test="@variety='struct'">
                  <xsl:value-of select="$vars//localizable/record"/>
                </xsl:when>
                <xsl:when test="@variety='classref'">
                  <xsl:value-of select="$vars//localizable/classref"/>
                </xsl:when>
                <xsl:when test="@variety='set'">
                  <xsl:value-of select="$vars//localizable/set"/>
                </xsl:when>
                <xsl:when test="@variety='array'">
                  <xsl:value-of select="$vars//localizable/array"/>
                </xsl:when>
                <xsl:when test="@variety='type'">
                  <xsl:value-of select="$vars//localizable/type"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:message>
                    *************************************************************************
                    ALERT! UNNAMED VARIETY <xsl:value-of select="@variety"/>
                    *************************************************************************
                </xsl:message>
              </xsl:otherwise>
            </xsl:choose>
            </xsl:attribute>
            
            <xsl:attribute name="Url">
              <xsl:variable name="prop_string" select="concat('html/', $namespace, $name, 'Type')"/> 
              <xsl:value-of select="translate($prop_string, '.', '')"/><xsl:text>.htm</xsl:text>
            </xsl:attribute>
          </HelpTOCNode>
        </xsl:for-each>
      </HelpTOCNode>
    </xsl:if>

    <!-- ##### routines ##### -->

        <xsl:if test="routine">
          <HelpTOCNode>
            <xsl:attribute name="Title">
              <xsl:value-of select="$vars/localizable/routines"/>
            </xsl:attribute>
        <xsl:for-each select="routine">

          <xsl:variable name="name">
            <xsl:value-of select="@name"/>
          </xsl:variable>
          <HelpTOCNode>
            <xsl:attribute name="Title">
              <xsl:value-of select="$name"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/routine"/>
            </xsl:attribute>
            
            <xsl:attribute name="Url">
              <xsl:variable name="prop_string" select="concat('html/', $namespace, $name, 'Routine')"/> 
              <xsl:value-of select="translate($prop_string, '.', '')"/><xsl:text>.htm</xsl:text>
            </xsl:attribute>

          </HelpTOCNode>
        </xsl:for-each>
      </HelpTOCNode>
    </xsl:if>



    <!-- ##### variables ##### -->

        <xsl:if test="variable">
          <HelpTOCNode>
            <xsl:attribute name="Title">
              <xsl:value-of select="$vars/localizable/variables"/>
            </xsl:attribute>
        <xsl:for-each select="variable">

          <xsl:variable name="name">
            <xsl:value-of select="@name"/>
          </xsl:variable>
          <HelpTOCNode>
            <xsl:attribute name="Title">
              <xsl:value-of select="$name"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/variable"/>
            </xsl:attribute>
            
            <xsl:attribute name="Url">
              <xsl:variable name="prop_string" select="concat('html/', $namespace, $name, 'Variable')"/> 
              <xsl:value-of select="translate($prop_string, '.', '')"/><xsl:text>.htm</xsl:text>
            </xsl:attribute>

          </HelpTOCNode>
        </xsl:for-each>
      </HelpTOCNode>
    </xsl:if>



    <!-- ##### constants ##### -->

        <xsl:if test="constant">
          <HelpTOCNode>
            <xsl:attribute name="Title">
              <xsl:value-of select="$vars/localizable/constants"/>
            </xsl:attribute>
        <xsl:for-each select="constant">

          <xsl:variable name="name">
            <xsl:value-of select="@name"/>
          </xsl:variable>
          <HelpTOCNode>
            <xsl:attribute name="Title">
              <xsl:value-of select="$name"/><xsl:text> </xsl:text><xsl:value-of select="$vars/localizable/constant"/>
            </xsl:attribute>
            
            <xsl:attribute name="Url">
              <xsl:variable name="prop_string" select="concat('html/', $namespace, $name, 'Constant')"/> 
              <xsl:value-of select="translate($prop_string, '.', '')"/><xsl:text>.htm</xsl:text>
            </xsl:attribute>

          </HelpTOCNode>
        </xsl:for-each>
      </HelpTOCNode>
    </xsl:if><!-- if there is/are constants -->

</HelpTOCNode>
</xsl:for-each><!--ends namespace foreach-->
</xsl:element> <!-- helptoc -->

</xsl:template>
 
</xsl:stylesheet>








